CONTAINER fx_fluidmesher
{
	NAME fx_fluidmesher;
	INCLUDE Obase;

	//Basic Tab
	GROUP ID_OBJECTPROPERTIES
	{			
		DEFAULT 1;
		BOOL FMESH_RENDERONLY {}
		LONG FMESH_CACHE_USECACHE_RAM 
		{
			ANIM OFF;
			CYCLE
			{
				FMESH_CACHE_USECACHE_RAM_OFF;
				FMESH_CACHE_USECACHE_RAM_POLY;
				FMESH_CACHE_USECACHE_RAM_ISO;
				FMESH_CACHE_USECACHE_RAM_BOTH;
			}
		}
		LINK FMESH_LINK {ACCEPT{fx_fluidsim;}; }
		LONG FMESH_PARTICLETYPE
		{
			CYCLE
			{
				FMESH_PARTICLETYPE_IMPLICIT;
				FMESH_PARTICLETYPE_FOAM;
				//FMESH_PARTICLETYPE_BUBBLES;
				FMESH_PARTICLETYPE_FLUID;
				FMESH_PARTICLETYPE_VORTICITY;
			}
		}
		LONG FMESH_PARTICLEGROUP
		{
			CYCLE
			{
			FMESH_PARTICLEGROUP_ALL;
			}
		}	
		BOOL FMESH_LEVELSET {}
		REAL FMESH_PARTICLE_DISTANCE {MIN 0.0;}
		LONG FMESH_SUBGRIDLAYER 
		{
			HIDDEN;
			CYCLE
			{	
				FMESH_SUBGRIDLAYER_PARENT;
			}
		}
		GROUP FMESH_SEP_RECONSTRUCT
		{
			DEFAULT 1;
			LONG FMESH_SURFACETYPE
			{
				CYCLE
				{
					FMESH_SURFACETYPE_WEIGHTED;
					FMESH_SURFACETYPE_ANISOTROPIC;
					//FMESH_SURFACETYPE_BLOBBY;
				}
			}
			GROUP
			{
				//BOOL FMESH_SORTNEIGHBORS {}
				LONG FMESH_SEARCHCOUNT_MIN { MIN 1; MAX 1000; }
				LONG FMESH_SEARCHCOUNT_MAX { MIN 1; MAX 1000; }
				LONG FMESH_UNITSPACE 
				{ 
					CYCLE
					{
						FMESH_UNITSPACE_PHYSICAL;
						FMESH_UNITSPACE_C4D;
					}
				}
				BOOL FMESH_PS_VARIABLE_RADIUS {}
				BOOL FMESH_PS_AUTORADIUS {}
				REAL FMESH_RADIUS {MIN 0.001; UNIT METER; STEP 0.1;}
				REAL FMESH_SMOOTHINGRADIUS {MIN 1; STEP 0.1;}
				REAL FMESH_ISOSURFACE { STEP 0.01;}

				GROUP FMESH_SEPID_ANISOTROPY
				{
					BOOL FMESH_PS_NEIGHBOR_ANISOTROPY {}
					BOOL FMESH_PS_VELOCITY_ANISOTROPY {}
					REAL FMESH_PS_VELOCITY_GAIN {MIN 0.01; MAX 10; STEP 0.01;}
				}

				GROUP FMESH_SEPID_GRIDSMOOTH
				{
					LONG FMESH_DIFFUSION_TYPE 
					{ 
						CYCLE
						{
							FMESH_DIFFUSION_TYPE_UNCLAMPED;
							FMESH_DIFFUSION_TYPE_CLAMPED;
							FMESH_DIFFUSION_TYPE_BLEND;
						}
					}
					REAL FMESH_DIFFUSION {MIN 0.0; STEP 0.1;}
					LONG FMESH_DIFFUSION_ITER { MIN 1; MAX 1000; }
					
					LONG FMESH_DIFFUSION_BLENDTYPE 
					{ 
						CYCLE
						{
							FMESH_DIFFUSION_BLENDTYPE_NORMAL;
							//FMESH_DIFFUSION_BLENDTYPE_MULTIPLY;
							FMESH_DIFFUSION_BLENDTYPE_DARKEN;
							FMESH_DIFFUSION_BLENDTYPE_LIGHTEN;
							//FMESH_DIFFUSION_BLENDTYPE_SCREEN;
							//FMESH_DIFFUSION_BLENDTYPE_OVERLAY;
							//FMESH_DIFFUSION_BLENDTYPE_HARDLIGHT;
							//FMESH_DIFFUSION_BLENDTYPE_SOFTLIGHT;
							FMESH_DIFFUSION_BLENDTYPE_CDODGE;
							FMESH_DIFFUSION_BLENDTYPE_CDODGEINV;
							//FMESH_DIFFUSION_BLENDTYPE_CBURN;
							FMESH_DIFFUSION_BLENDTYPE_SOFTBURN;
							FMESH_DIFFUSION_BLENDTYPE_DIFF;
							//FMESH_DIFFUSION_BLENDTYPE_NDIFF;
							FMESH_DIFFUSION_BLENDTYPE_EXCLUDE;
							//FMESH_DIFFUSION_BLENDTYPE_REFLECT;
							FMESH_DIFFUSION_BLENDTYPE_ADD;
							FMESH_DIFFUSION_BLENDTYPE_SUB;
						}
					}
					REAL FMESH_DIFFUSION_BLEND {MIN 0.0; MAX 1.0; STEP 0.1;}
				}
				GROUP FMESH_SEPID_SIMBDR
				{
					BOOL FMESH_CUTBDR {}
					IN_EXCLUDE FMESH_CUTOBJECTS
					{
						NUM_FLAGS 0; INIT_STATE 0; SEND_SELCHNGMSG 1;
						ACCEPT {  Obase; };
					}
					BOOL FMESH_CUTBDR_AFTERDIFFUSION {}
					REAL FMESH_BDRCUT {STEP 0.001;}
					LONG FMESH_SINGLECORE { MIN 0; MAX 256; }
				}
			}
		}
		GROUP FMESH_SEP_MESHING
		{
			DEFAULT 1;
			LONG FMESH_TYPE
			{
				CYCLE
				{
					FMESH_TYPE_CUBES;
					FMESH_TYPE_TETRA;
					FMESH_TYPE_TILES;
				}
			}
			LONG FMESH_SIZEX {MIN 10; }
			LONG FMESH_SIZEX_RENDER {MIN 10; }
			REAL FMESH_ADVECTION {MIN 0.0; MAX 10000000.0; STEP 0.001;}
			BOOL FMESH_CALCNORMALS {}
			BOOL FMESH_OPTIMIZE {}
			REAL FMESH_ADVECTIONPARTICLES {MIN 0.0; MAX 10000000.0; STEP 0.001; HIDDEN; }
		}
	}
	GROUP ID_FMESH_CACHE
	{
		LONG FMESH_CACHE_MODE 
		{
			ANIM OFF;
			CYCLE
			{
				FMESH_CACHE_MODE_OFF;
				FMESH_CACHE_MODE_LOAD;
				FMESH_CACHE_MODE_SAVE;
			}
		}
		
		SEPARATOR{LINE;}

		GROUP
		{
			COLUMNS 2;
			BUTTON FMESH_CACHE_FILE {}
			BUTTON FMESH_CACHE_CLEAR {}
			BUTTON FMESH_CACHE_SINGLEFRAME {HIDDEN;}
		}
		STRING FMESH_CACHE_FILENAME {ANIM OFF;}
		STRING FMESH_CACHE_FILENAME_NAME {ANIM OFF;}
		
		SEPARATOR{}
				
		GROUP FMESH_CACHERENDER_SID
		{
			DEFAULT 1;
			BOOL FMESH_CACHE_USECACHE_EXTERNAL {ANIM OFF;}
			GROUP
			{
				COLUMNS 2;
				LONG FMESH_CACHE_CFRAME {MIN -1; }
				LONG FMESH_CACHE_OFFSET {}
			}
			SEPARATOR{LINE;}
			GROUP 
			{
				COLUMNS 2;
				BOOL FMESH_CACHE_LOAD_ISO {}
				BOOL FMESH_CACHE_LOAD_POLY {}
			}
			SEPARATOR{LINE;}
			
			STRING FMESH_CACHEFILE_INFO { CUSTOMGUI MULTISTRING; }
		}
		GROUP FMESH_CACHEEDITOR_SID
		{
			DEFAULT 1;
			LONG FMESH_CACHE_SAVEMODE 
			{
				ANIM OFF;
				CYCLE
				{
					FMESH_CACHE_SAVEMODE_DISK;
					FMESH_CACHE_SAVEMODE_DISKRENDER;
				}
			}
			BOOL FMESH_CACHE_SAVECACHE_COMPRESS {ANIM OFF; }
			SEPARATOR{LINE;}

			GROUP
			{
				COLUMNS 2;
				BOOL FMESH_CACHE_SAVE_ISO {ANIM OFF; }
				BOOL FMESH_CACHE_SAVE_POLY {ANIM OFF; }
			}
		}
	}
}